 ; Ŀ
 ;   Dbf - duplicate block finder - find superimposed blocks.              
 ;   Copyright 2007 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Albo - get a list of all blocks in the drawing.                       
 ;   Takes no arguments, calls nothing, returns a list.                    
 ; 
 (DEFUN ALBO (/ rew nexb namm blist)
  (setq rew T)
  (while (setq nexb (tblnext "block" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 nexb)))
         (setq blist (cons namm blist)))
 blist)
 ; Ŀ
 ;   Albo end.                                                             
 ; 

 ; Ŀ
 ;   Posit - find any entities in an ss which are close together.          
 ;   Arguments: Dis, the minimum distance.                                 
 ;              Ss, the selection set.                                     
 ;   Indicates the blocks in some curently un-thought-of fashion.          
 ;   Also prints a message of some type.                                   
 ; 
 (DEFUN POSIT (dis ss / num enam numsub dista pa pb)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq numsub (setq num (1+ num)))
         (while (setq nxnam (ssname ss numsub))
                (setq numsub (1+ numsub))
                (setq dista (distance (setq pa (cdr (assoc 10 (entget enam))))
                                    (setq pb (cdr (assoc 10 (entget nxnam))))))
                (if (<= dista dis)
                    (progn
                         (grdraw pa (getvar "viewctr") 1)
                         (grdraw pb (getvar "viewctr") 1)
                         (grdraw pa pb 1)
                         (write-line "*")))))
 princ)
 ; Ŀ
 ;   Posit end.                                                            
 ; 

 ; Ŀ
 ;   Dbf.                                                                  
 ; 
 (DEFUN C:DBF (/ blnam blist ss)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Call Albo to get a list of all blocks in the drawing.                 
 ; 
  (setq blist (albo))
  (setq num 0)
  (while (setq blnam (nth num blist))
         (setq num (1+ num))
         (if (setq ss (ssget "x" (list (cons 2 blnam))))
             (posit 5 ss)))
 (princ))